#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fcntl.h>      /* open */
//#include <unistd.h>     /* exit */
#include <sys/ioctl.h>  /* ioctl */

#define PORT_UNKNOWN            0
#define EUART_232_V1            1
#define EUART_422485_V1         2
#define EUART_A9610_232_V1      3
#define EUART_A9610_422485_V1   4

#include "serial_rdc_ioctl.h"
 
int main(int argc, char** argv)
{
    int result;
    
    int Device_tty;
    
    
    if (argc < 2)
    {
        printf("example: ./EUART485 /dev/ttyRDC0 \n");
    }
    
    Device_tty = open(argv[1], O_RDWR | O_NOCTTY);
    if (Device_tty < 0)
    {
        printf("%s can not find \n", argv[1]);
        return -1;
    }
    
    result = ioctl(Device_tty, IOCTL_Goto485Mode, 0);
    if (result < 0)
    {
        printf("IOCTL_Goto485Mode failed:%d \n", result);
    }
    
    
    close(Device_tty);
    
    return 0;
}
